using System;
using Server;
using Server.Misc;
using Server.Items;
using Server.Spells.Spellweaving;
using Server.Network;

namespace Server.Mobiles
{
	//[CorpseName( "a forest elf corpse" )]
	public class DarkElf : BaseCreature
	{
		private DateTime m_NextSpeechTime = DateTime.Now;
		
		public static int RandomDarkElfHairHue { get { return Utility.RandomList( 1102, 2101, 2119, 2119, 1321, 1361, 1246, 106 ); } }
		public static int RandomDarkElfSkinHue { get { return Utility.RandomMinMax( 1102, 1109 ) | 0x8000; } }
		
		public static string[] ElfSay { get { return new string[]
				{
					"Lle quena i’lambe tel’ Eldalie?", //Do you speak elvish?
					"Lle holma ve’ edan", //You smell like a human
					"Dolle naa lost", //Your head is empty
					"Ed’ i’ear ar’ elenea!", //By the sea and stars!
					"Auta miqula orqu", //Go kiss an orc!
					"Amin delotha lle!", //I hate you!
					"Amin feuya ten’ lle", //You disgust me
					"Gurth gothrim Tel’Quessir!", //Death to the foes of the Elves
					"I’narr en gothrim glinuva nuin I’anor", //The bones of our foes will gleam under the sun
					"Lle n'vanima ar' lle atara lanneina", //You're ugly and your mother dresses you funny
					"Amin delotha Ile", // I hate you
					"Lasta lalaithamin", // Listen to my laughter
					"Antolle ulua sulrim", // Much wind pours from your mouth
					"Utinu en lokirim", // Son of snakes (dishonest person)
					"Lle naa haran e’ nausalle" // You are king in your imagination
				}; } }
		
		public override bool ShowFameTitle{ get{ return false; } }
		public override bool AlwaysMurderer{ get{ return true; } }
		public override int TreasureMapLevel{ get{ return 4; } }
		public override bool CanRummageCorpses{ get{ return true; } }
		
		public override WeaponAbility GetWeaponAbility()
		{
			switch ( Utility.Random( 3 ) )
			{
				default:
					case 0: return WeaponAbility.Bladeweave;
					case 1: return WeaponAbility.ForceOfNature;
					case 2: return WeaponAbility.PsychicAttack;
			}
		}
		
		[Constructable]
		public DarkElf() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Hue = RandomDarkElfSkinHue;
			SpeechHue = Utility.RandomDyedHue();
			EmoteHue = Utility.RandomNeutralHue();
			
			if ( Female = Utility.RandomBool() )
			{
				Body = 606;
				Name = NameList.RandomName( "dark elf female" );
			}
			else
			{
				Body = 605;
				Name = NameList.RandomName( "dark elf male" );
			}
			// hair, facial hair
			HairItemID = Race.Elf.RandomHair( Female );
			HairHue = RandomDarkElfHairHue;
			Race = Race.Elf;
			Title = "the Dark elf";
			
			SetStr( 306, 500 );
			SetDex( 120, 165 );
			SetInt( 100, 105 );

			SetDamage( 19, 29 );
			SetHits( 751, 795 );
			SetMana( 1450, 1500 );
			
			// 			SetDamageType( ResistanceType.Physical, 100 );

			SetResistance( ResistanceType.Physical, 50, 70 );
			SetResistance( ResistanceType.Fire, 50, 70 );
			SetResistance( ResistanceType.Cold, 60, 65 );
			SetResistance( ResistanceType.Poison, 55, 60 );
			SetResistance( ResistanceType.Energy, 50, 65 );

			SetSkill( SkillName.SpiritSpeak, 80.0, 100.0 );
			SetSkill( SkillName.MagicResist, 80.0, 110.0 );
			SetSkill( SkillName.Swords, 100.0, 130.0 );
			SetSkill( SkillName.Fencing, 100.0, 130.0 );
			SetSkill( SkillName.Macing, 100.0, 130.0 );
			SetSkill( SkillName.Tactics, 100.0, 130.0 );
			SetSkill( SkillName.Wrestling, 100.0, 130.0 );
			SetSkill( SkillName.Anatomy, 100.0, 110.0 );
			SetSkill( SkillName.ArmsLore, 80.0, 110.0 );
			SetSkill( SkillName.Parry, 60.0, 90.0 );
			SetSkill( SkillName.Hiding, 100.1 );
			SetSkill( SkillName.DetectHidden, 100.1, 120.0 );
			SetSkill( SkillName.Healing, 70.0, 90.0 );
			SetSkill( SkillName.AnimalTaming, 120.0 );
			SetSkill( SkillName.AnimalLore, 120.0 );
			SetSkill( SkillName.Spellweaving, 110.1, 120.0 );
			
			// outfit
			BaseArmor arms = new WoodlandArms();
			//          arms.Resource = CraftResource.BarbedLeather;
			arms.Movable = false;
			AddItem( arms );

			BaseArmor chest = new WoodlandChest();
			//          chest.Resource = CraftResource.BarbedLeather;
			chest.Movable = false;
			AddItem( chest );

			BaseArmor gloves = new WoodlandGloves();
			//          gloves.Resource = CraftResource.BarbedLeather;
			gloves.Movable = false;
			AddItem( gloves );
			BaseArmor gorget = new WoodlandGorget();
			//          gorget.Resource = CraftResource.BarbedLeather;
			gorget.Movable = false;
			AddItem( gorget );
			BaseArmor legs = new WoodlandLegs();
			//          legs.Resource = CraftResource.BarbedLeather;
			legs.Movable = false;
			AddItem( legs );
			if ( Utility.RandomDouble() < 0.8 )
			{
				Item cloak = new Cloak();
				cloak.Hue = Utility.RandomMinMax( 1902, 1908 );
				
				if ( Utility.RandomDouble() < 0.3 )
				{
					cloak.ItemID = 11013;
					cloak.Movable = false;
				}
				
				AddItem( cloak );
			}
			/*if ( Utility.RandomDouble() < 0.1 )
			{
				if ( this.Female )
				{
					Item femalerobe = new FemaleElvenRobe();
					if (Utility.RandomDouble() < 0.3)
						femalerobe.Hue = Utility.RandomNeutralHue();
					femalerobe.Movable = ( Utility.RandomDouble() < 0.005 ) ? true : false;
					AddItem( femalerobe );
				}
				else
				{
					Item robe = new MaleElvenRobe();;
					if (Utility.RandomDouble() < 0.3)
						robe.Hue = Utility.RandomNeutralHue();
					robe.Movable = ( Utility.RandomDouble() < 0.005 ) ? true : false;
					AddItem( robe );
				}
			}*/
			if ( Utility.RandomBool() )
			{
				Item belt = new WoodlandBelt( 2406 );
				belt.Movable = false;
				AddItem( belt );
			}
			Item boots = new ElvenBoots( 2406 );
			boots.Movable = ( Utility.RandomDouble() < 0.01 ) ? true : false;
			AddItem( boots );
			//talismany
			if ( Utility.RandomDouble() < 0.0001 )
			{
				AddItem( new DridersChitinFragment() );
			}
			else
			{
				Item talisman = new RandomTalisman();
				talisman.Movable = false;
				AddItem( talisman );
			}

			switch ( Utility.Random( 10 ) )
			{
				case 0:
					{
						BaseArmor ravenhelm = new RavenHelm();
						//                ravenhelm.Resource = CraftResource.Obsidian;
						ravenhelm.Movable = false;
						AddItem( ravenhelm );
					}
					break;
				case 1:
					{
						BaseArmor royalcirclet = new RoyalCirclet();
						//                royalcirclet.Resource = CraftResource.Obsidian;
						royalcirclet.Movable = false;
						AddItem( royalcirclet );
					}
					break;
				case 2:
					{
						BaseArmor vulturehelm = new VultureHelm();
						//                vulturehelm.Resource = CraftResource.Obsidian;
						vulturehelm.Movable = false;
						AddItem( vulturehelm );
					}
					break;
				case 3:
					{
						BaseArmor wingedhelm = new WingedHelm();
						//                wingedhelm.Resource = CraftResource.Obsidian;
						wingedhelm.Movable = false;
						AddItem( wingedhelm );
					}
					break;
				case 4:
					{
						BaseArmor gemmedcirclet = new GemmedCirclet();
						//                gemmedcirclet.Resource = CraftResource.Obsidian;
						gemmedcirclet.Movable = false;
						AddItem( gemmedcirclet );
					}
					break;
			}

			switch ( Utility.Random( 2 ) )
			{
				case 0:
					switch ( Utility.Random( 5 ))
					{
						case 0:
							{
								BaseWeapon spear = new Spear();
								if ( Utility.RandomBool() )
									spear.Resource = CraftResource.ShadowIron;
								spear.Movable = false;
								AddItem( spear );
							}
							break;
						case 1:
							{
								BaseWeapon elvenspellblade = new ElvenSpellblade();
								if ( Utility.RandomBool() )
									elvenspellblade.Resource = CraftResource.ShadowIron;
								elvenspellblade.Movable = false;
								AddItem( elvenspellblade );
							}
							break;
						case 2:
							{
								BaseWeapon ornateaxe = new OrnateAxe();
								if ( Utility.RandomBool() )
									ornateaxe.Resource = CraftResource.ShadowIron;
								ornateaxe.Movable = false;
								AddItem( ornateaxe );
							}
							break;
						case 3:
							{
								BaseWeapon runeblade = new RuneBlade();
								if ( Utility.RandomBool() )
									runeblade.Resource = CraftResource.ShadowIron;
								runeblade.Movable = false;
								AddItem( runeblade );
							}
							break;
						case 4:
							{
								BaseWeapon wildstaff = new DoubleBladedStaff();
								if ( Utility.RandomBool() )
									wildstaff.Resource = CraftResource.ShadowIron;
								wildstaff.Movable = false;
								AddItem( wildstaff );
							}
							break;
					}
					break;
				case 1:
					switch ( Utility.Random( 6 ))
					{
						case 0:
							{
								BaseWeapon assassinspike = new AssassinSpike();
								if ( Utility.RandomBool() )
									assassinspike.Resource = CraftResource.ShadowIron;
								assassinspike.Movable = false;
								AddItem( assassinspike );
							}
							break;
						case 1:
							{
								BaseWeapon diamondmace = new DiamondMace();
								if ( Utility.RandomBool() )
									diamondmace.Resource = CraftResource.ShadowIron;
								diamondmace.Movable = false;
								AddItem( diamondmace );
							}
							break;
						case 2:
							{
								BaseWeapon elvenmachete = new ElvenMachete();
								if ( Utility.RandomBool() )
									elvenmachete.Resource = CraftResource.ShadowIron;
								elvenmachete.Movable = false;
								AddItem( elvenmachete );
							}
							break;
						case 3:
							{
								BaseWeapon leafblade = new Leafblade();
								if ( Utility.RandomBool() )
									leafblade.Resource = CraftResource.ShadowIron;
								leafblade.Movable = false;
								AddItem( leafblade );
							}
							break;
						case 4:
							{
								BaseWeapon radiantscimitar = new RadiantScimitar();
								if ( Utility.RandomBool() )
									radiantscimitar.Resource = CraftResource.ShadowIron;
								radiantscimitar.Movable = false;
								AddItem( radiantscimitar );
							}
							break;
						case 5:
							{
								BaseWeapon warcleaver = new WarCleaver();
								if ( Utility.RandomBool() )
									warcleaver.Resource = CraftResource.ShadowIron;
								warcleaver.Movable = false;
								AddItem( warcleaver );
							}
							break;
					}
					switch ( Utility.Random( 3 ))
					{
						case 0:
							{
								BaseShield bronzeshield = new MetalShield();
								bronzeshield.Resource = CraftResource.ShadowIron;
								bronzeshield.Movable = false;
								AddItem( bronzeshield );
							}
							break;
						case 1:
							{
								BaseShield woodenshield = new MetalKiteShield();
								woodenshield.Resource = CraftResource.ShadowIron;
								woodenshield.Movable = false;
								AddItem( woodenshield );
							}
							break;
						case 2:
							{
								BaseShield bronzeshield = new BronzeShield();
								bronzeshield.Resource = CraftResource.ShadowIron;
								bronzeshield.Movable = false;
								AddItem( bronzeshield );
							}
							break;
					}
					break;
			}
			//end outfit
			
			PackItem( new Bandage( Utility.RandomMinMax( 10, 15 ) ) );
			// 			PackGold( 100, 200 );

			Fame = 6000;
			Karma = -7000;
			VirtualArmor = 0;
			
			if ( Utility.RandomDouble() < 0.2 )
				new DarkZostrich().Rider = this;
		}
		
		// 		public override void OnDeath( Container c )
		// 		{
		// 			base.OnDeath( c );

		// 			if ( Utility.RandomDouble() < 0.05 )
		//             c.DropItem( new ForestElvesAmulet() );
		// 		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.UltraRich );
		}
		
		public override bool IsNotScaredOfDeath{ get{ return Utility.RandomBool(); } } //neutika pri malem poctu hp - sance 50%
		
		public override void OnMovement( Mobile m, Point3D oldLocation )
		{
			if ( !this.Hidden && DateTime.Now > m_NextSpeechTime && m.InRange( this, 3 ) && m is PlayerMobile )
			{
				m_NextSpeechTime = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 10, 20 ) );
				SayRandom( ElfSay, this );
				this.Move( GetDirectionTo( m.Location ) );
			}
		}
		
		public override void OnDamagedBySpell( Mobile attacker )
		{
			if ( 0.6 > Utility.RandomDouble() && !attacker.InRange( this, 1 ) )
			{
				int effId = 0x2D22;
				
				if ( this.Weapon is BaseWeapon && !( this.Weapon is Fists ) )
					effId = ((Item)this.Weapon).ItemID;
				
				Effects.SendPacket( attacker, attacker.Map, new HuedEffect( EffectType.Moving, Serial.Zero, Serial.Zero, effId, this.Location, attacker.Location, 10, 0, false, false, 0, 0 ) );
				AOS.Damage( attacker, this, Utility.RandomMinMax( 70, 125 ), 50, 0, 0, 0, 50 );
			}
			else
				base.OnDamagedBySpell( attacker );
		}
		
		public override bool OnBeforeDeath()
		{
			IMount mount = this.Mount;
			if   ( mount != null )
				mount.Rider = null;
			
			if ( mount is Mobile )
			{
				if ( Utility.RandomDouble() > 0.0001 || this.Map == Map.Underworld )
					((Mobile)mount).Delete();
				else
					((Mobile)mount).Combatant = this.Combatant;
			}
			
			return base.OnBeforeDeath();
		}
		
		private static void SayRandom( string[] say, Mobile m )
		{
			m.Say( say[Utility.Random( say.Length )] );
		}
		
		public override void OnActionCombat()
		{
			if ( this.Combatant != null && Utility.RandomDouble() < 0.025 )
			{
				switch ( Utility.Random( 3 ) )
				{
					case 0:
						{
							new AttunementSpell( this, null ).Cast();
						}
						break;
					case 1:
						{
							new ImmolatingWeaponSpell( this, null ).Cast();
						}
						break;
					case 2:
						{
							this.BandageSelf();
							this.Emote( "* begin apllying bandages *" );
						}
						break;
				}
			}
			base.OnActionCombat();
		}
		
		public DarkElf( Serial serial ) : base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
		}
	}
}
